// DownloadDlg.cpp : implementation file
//
// Copyright (c) 2000-2001 Marc Ramsey. All rights reserved.
//
// http://www.ranlog.com/ramsey/
//
// This software is provided as is with no warranties of any kind, 
// including the warranties of design, merchantibility and fitness 
// for a particular purpose, noninfringement, or arising from a 
// course of dealing, usage or trade practice.  This software is 
// provided with no support and without any obligation to assist in 
// its use, correction, modification, or enhancement.
//
// Permission to use, copy, or modify this software for any purpose 
// is hereby granted without fee, provided the above notices are 
// retained on all copies of the source code. 

#include "stdafx.h"
#include "IGCshell.h"
#include "DownloadDlg.h"
#include "DirDialog.h"
#include "IGCAPI.H"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CIGCshellApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CDownloadDlg dialog


CDownloadDlg::CDownloadDlg(CWnd* pParent)
	: CDialog(CDownloadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDownloadDlg)
	//}}AFX_DATA_INIT
}


void CDownloadDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDownloadDlg)
	DDX_Control(pDX, IDOK, m_close);
	DDX_Control(pDX, IDC_LOGNAME, m_log_name);
	DDX_Control(pDX, IDC_FLIGHT_RECORDER_ID, m_flight_recorder_id);
	DDX_Control(pDX, IDC_DOWNLOADING_TO, m_download_dir);
	DDX_Control(pDX, IDC_STATUS, m_status);
	DDX_Control(pDX, IDC_LIST_HEADING, m_list_heading);
	DDX_Control(pDX, IDC_DOWNLOAD_VALIDATE, m_validate);
	DDX_Control(pDX, IDC_DOWNLOAD_ONE, m_download_one);
	DDX_Control(pDX, IDC_DOWNLOAD_LIST, m_download_list);
	DDX_Control(pDX, IDC_DOWNLOAD_CONVERT, m_convert);
	DDX_Control(pDX, IDC_DOWNLOAD_ALL, m_download_all);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDownloadDlg, CDialog)
	//{{AFX_MSG_MAP(CDownloadDlg)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_DOWNLOAD_ALL, OnDownloadAll)
	ON_LBN_SELCHANGE(IDC_DOWNLOAD_LIST, OnChangeDownloadList)
	ON_LBN_DBLCLK(IDC_DOWNLOAD_LIST, OnDblclkDownloadList)
	ON_BN_CLICKED(IDC_DOWNLOAD_ONE, OnDownloadOne)
	ON_BN_CLICKED(IDC_DOWNLOAD_VALIDATE, OnDownloadValidate)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
//	ON_COMMAND(IDHELP, OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDownloadDlg message handlers

BOOL CDownloadDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// Open serial port

	CString options;

	options = theApp.GetProfileString(theApp.mFlightRecorder, _T("SerialOptions"));
	if (!SerialConnectFR(theApp.mCommPort, (LPCTSTR)options)) {
		EndDialog(-1);
		return TRUE;
	}

	// Set timer for KeepAwakeFR
	if (m_timer_interval = KeepAwakeIntervalDLL()) {
		m_timer_id = SetTimer(1, m_timer_interval, NULL);
		if (m_timer_id == 0) {
			AfxMessageBox(IDS_NO_TIMER, MB_OK|MB_ICONSTOP);
			EndDialog(-1);
			return TRUE;
		}
		// Prime the pump
		KeepAwakeFR();
	}

	// Set log list font

	LOGFONT lf;
	memset(&lf, 0, sizeof(LOGFONT));
	lf.lfHeight = 90;
	lf.lfPitchAndFamily = FIXED_PITCH|FF_MODERN;
	strcpy(lf.lfFaceName, "Lucida Console");
	if (!m_fixed_font.CreatePointFontIndirect(&lf)) {
		*lf.lfFaceName = '\0';
		m_fixed_font.CreatePointFontIndirect(&lf);
	}
	m_download_list.SetFont(&m_fixed_font);
	m_list_heading.SetFont(&m_fixed_font);
	m_log_name.SetFont(&m_fixed_font);

	// Initialize log list items

	int index = -1;
	TCHAR buffer[128], item[128];
	m_download_list.ResetContent();

	while (IdentifyLogFR(++index, buffer, sizeof(buffer)) > 0) {
		LPCTSTR filename = _tcstok(buffer, _T("|"));
		LPCTSTR date = _tcstok(NULL, _T("|"));
		LPCTSTR start = _tcstok(NULL, _T("|"));
		LPCTSTR end = _tcstok(NULL, _T("|"));
		LPCTSTR pilot = _tcstok(NULL, _T("|"));
		LPCTSTR compId = _tcstok(NULL, _T("|"));
		LPCTSTR compClass = _tcstok(NULL, _T("|"));
		_stprintf(item, "%-12.12s %-10.10s %-8.8s %-8.8s %-4.4s %-6.6s %-s",
			filename, date, start, end, compId, compClass, pilot);
		m_download_list.AddString(item);
	}

	if (m_download_list.GetCount() == 0) {
		// No flight data files available
		CString noData;
		noData.LoadString(IDS_NO_FLIGHT_DATA);
		m_download_list.AddString((LPCTSTR)noData);
		m_download_list.EnableWindow(FALSE);
		m_download_all.EnableWindow(FALSE);
	} else {
		// Flight data available, enable list and 
		// Download All button
		m_download_list.EnableWindow(TRUE);
		m_download_all.EnableWindow(TRUE);
	}

	// Set other control states and values

	CString flightRecorder;
	LPCTSTR model, serial, sealed;

	IdentifyFR(buffer, sizeof(buffer));
	serial = _tcstok(buffer, _T("|"));
	model = _tcstok(NULL, _T("|"));
	sealed = _tcstok(NULL, _T("|"));
	flightRecorder.LoadString(IDS_FR_ID);
	flightRecorder += model;
	flightRecorder += _T(" ");
	flightRecorder += serial;
	flightRecorder += _T(" ");
	flightRecorder += sealed;
	m_flight_recorder_id.SetWindowText(flightRecorder);

	CString downloadDir;
	downloadDir.LoadString(IDS_DOWNLOADING_TO);
	downloadDir += theApp.mDownloadDirectory;
	m_download_dir.SetWindowText(downloadDir);
	m_validate.SetCheck(theApp.mDownloadValidate);
	m_convert.SetCheck(theApp.mDownloadConvert);
	m_download_one.EnableWindow(FALSE);
	m_convert.EnableWindow(UseConvertLog());
	m_log_name.SetWindowText(_T(""));
	m_log_name.EnableWindow(FALSE);
	m_last_selection = LB_ERR;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDownloadDlg::OnDestroy() 
{
	// Disconnect from flight recorder
	DisconnectFR();
	// Kill timer
	if (m_timer_interval)
		KillTimer(m_timer_id);
	// Save checkbox states
	theApp.mDownloadValidate = m_validate.GetCheck();
	theApp.mDownloadConvert = m_convert.GetCheck();

	CDialog::OnDestroy();
}

BOOL CDownloadDlg::download(int index, LPCTSTR logname)
{
	CString filename, filepath, status;
	// Get default log filename
	m_download_list.GetText(index, filename);
	filename = filename.SpanExcluding(" ");
	filepath = theApp.mDownloadDirectory;
	if (!filepath.IsEmpty() && filepath[filepath.GetLength() - 1] != '\\')
		filepath += '\\';
	// Alternate log name specified?
	if (logname != NULL && *logname != '\0') {
		int iext = filename.ReverseFind('.');
		// Use log name and default extension
		filepath += logname;
		if (iext >= 0)
			filepath += ((LPCTSTR)filename) + iext; 
	} else
		filepath += filename;

	// Download log file

	status.LoadString(IDS_DOWNLOADING);
	status += filename;
	m_status.SetWindowText(status);
	if (!DownloadLogFR(index, filepath)) {
		status.LoadString(IDS_DOWNLOAD_FAILED);
		status += filename;
		m_status.SetWindowText(status);
		return FALSE;
	}
	status.LoadString(IDS_DOWNLOAD_COMPLETE);
	status += filename;
	m_status.SetWindowText(status);

	// If requested, validate log

	if (m_validate.GetCheck()) {
		if (!ValidateLog(filepath)) {
			status.LoadString(IDS_VALIDATE_FAILED);
			status += filename;
			m_status.SetWindowText(status);
			return FALSE;
		}
		status.LoadString(IDS_VALIDATE_COMPLETE);
		status += filename;
		m_status.SetWindowText(status);
	}

	// If requested, convert log to IGC format

	if (m_convert.GetCheck()) {
		CString igcpath = filepath;
		int dot = igcpath.ReverseFind('.');
		if (dot > 0)
			igcpath.Delete(dot, igcpath.GetLength() - dot);
		igcpath += _T(".IGC");
		if (!ConvertLog(filepath, igcpath)) {
			status.LoadString(IDS_CONVERT_FAILED);
			status += filename;
			m_status.SetWindowText(status);
			return FALSE;
		}
		status.LoadString(IDS_CONVERT_COMPLETE);
		status += filename;
		m_status.SetWindowText(status);
	}
	return TRUE;
}

void CDownloadDlg::OnDownloadAll() 
{
	CString status;

	// Download all logs in FR

	for (int i = 0; i < m_download_list.GetCount(); i++)
		if (!download(i, NULL))
			return;

	status.LoadString(IDS_DOWNLOAD_ALL);
	m_status.SetWindowText(status);
}

void CDownloadDlg::OnChangeDownloadList() 
{
	int index = m_download_list.GetCurSel();
	if (index != LB_ERR) {
		CString filename;
		if (index != m_last_selection) {
			// Extract base name of default filename
			m_download_list.GetText(index, filename);
			filename = filename.SpanExcluding(". ");
			m_log_name.SetWindowText((LPCTSTR)filename);
		}
		// Enable Download button and Log Name edit box
		m_download_one.EnableWindow(TRUE);
		m_log_name.EnableWindow(TRUE);
		SetDefID(IDC_DOWNLOAD_ONE);
	} else {
		// Disable Download button and Log Name edit box
		m_log_name.SetWindowText(_T(""));
		m_download_one.EnableWindow(FALSE);
		m_log_name.EnableWindow(FALSE);
		SetDefID(IDOK);
	}
	m_last_selection = index;
}

void CDownloadDlg::OnDblclkDownloadList() 
{
	OnDownloadOne();
}

void CDownloadDlg::OnDownloadOne() 
{
	CString logname;
	// Get log name from edit box, trim leading and trailing spaces
	m_log_name.GetWindowText(logname);
	logname.TrimLeft();
	logname.TrimRight();
	download(m_download_list.GetCurSel(), (LPCTSTR)logname);
}

void CDownloadDlg::OnDownloadValidate() 
{
}

void CDownloadDlg::OnOK() 
{
	CDialog::OnOK();
}

void CDownloadDlg::OnTimer(UINT nIDEvent) 
{
	// Send keep awake to FR

	if (!KeepAwakeFR()) {
		// Flight recorder has disconnected
		AfxMessageBox(IDS_FR_DISCONNECT, MB_OK|MB_ICONWARNING);
		EndDialog(-1);
	}

	CDialog::OnTimer(nIDEvent);
}

BOOL CDownloadDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	BOOL result = TRUE;

	if (pHelpInfo->iContextType == HELPINFO_WINDOW)
		AfxGetApp()->WinHelp(pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	else
		result = CDialog::OnHelpInfo(pHelpInfo);

	return result;
}
