Attribute VB_Name = "S1X_FNC"
'########################################################################################################
'######################################### S1X-HAUPT-MODUL ##############################################
'########################################################################################################


  #If Win32 Then
    Declare Sub SetCursorPos Lib "User32" (ByVal X As Integer, ByVal Y As Integer)
    Declare Sub GetCursorPos Lib "User32" (lpPoint As POINTAPI)
    
    Type POINTAPI
      X As Long
      Y As Long
    End Type
  
  #Else

    Declare Sub SetCursorPos Lib "User" (ByVal X As Integer, ByVal Y As Integer)
    Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
    
    Type POINTAPI
      X As Integer
      Y As Integer
    End Type
  
  #End If


'................................................................ StandartParameter von Listen-Formularen
Type S1X_REC_DAT
  LFTfrm As Integer: TOPfrm As Integer '................................................ FormularPosition
  NBRrow As Integer '......................................................... Anzahl Zeilen des Fensters
  NBRrec As Integer '..................................................................... Anzahl Records
  RECdat(999) As String '.............................................................. Daten der Records
  NBRscr As Integer '......................................................... Anzahl gescrollter Records
  IDXrec As Integer '........................................................ Index des aktuellen Records
  TABlst(22) As Integer '............................................................ TabulatorPositionen
End Type

'................................................................................... MousePointerPosition
Global APIpos As POINTAPI

'............................................................................. StandartWinkel in BogenMa
Global Pi090 As Double: Global Pi180 As Double
Global Pi270 As Double: Global Pi360 As Double


'----------------------------------------- PROGRAMM-STEUERUNG -------------------------------------------
Global DIRhom_s1x As String '........................................................... StammVerzeichnis
Global OBJfrm_s1x As Object '......................................... FormularObjekt globaler Prozeduren
Global LCDlng_s1x As String '............................................. LnderCode der AnwenderSprache
Global S1Xwrk_end As Integer '.................... Flag ProgrammEnde (keine Reaktion mehr auf UserEvents)
Global MODedt_wrk As String '......................................... Modus EditorAufruf (UPDATE/INSERT)
Global PTHcnt_imp As String '....................................................... Aktueller ImportPfad
Global LSTfrm_opn As String '................................................... Liste der HauptFormulare
Global S1Xzom_stp As Double '.......................................... SchrittKonstante fr FormularZoom

'............................................................................................. KONSTANTEN
Global DTMsys_nbr As String '..................................................... SystemDatum DD.MM.YYYY

'---------------------------------------------- DATENBANK  ----------------------------------------------
Global PTHdbs_s1x As String '.................................................. Verzeichnis der Datenbank
Global DBSver_s1x As String '................................................ dBASE-Version der Datenbank
Global DBScnn_s1x As Integer '...... DatenbankVerfgbarkeit (0=nicht verfgbar, 1=leer, 2=Daten abrufbar)
Global DBSobj_s1x As Database '.......................................................... DatenbankObjekt
Global CRSobj_s1x As Recordset '......................................................... DatenbankCursor
Global CRSobj_tmp As Recordset '......................................................... DatenbankCursor

Global IDXcnt_s1x As Integer '........................................... Index des aktuellen Wettbewerbs
Global IDXcnt_imp As Integer '........................................ Index des importierten Wettbewerbs
Global IDXfly_s1x As Integer '................................................ Index des aktuellen Fluges

'----------------------------------------- GLOBALE FORMULARE --------------------------------------------
'............................................................................................... SETTINGS
Global LFTfrm_set As Integer, TOPfrm_set As Integer '............................ Position GlobalSettings

'................................................................................................... STOP
Global TXTmsg_stp As String '..................................................... Text der FehlerMeldung
Global LFTfrm_stp As Integer, TOPfrm_stp As Integer '.............................. Position der STOPForm
Global MODmsg_stp As Integer '................................................... StopModus (1 = Enabled)

'................................................................................................... INFO
Global TAGinf_txt As String '................................................................ InfoCaption
Global LFTfrm_inf As Integer, TOPfrm_inf As Integer '.............................. Position der InfoForm

'....................................................................................... KONTROLL-ABFRAGE
Global TXTmsg_ask As String '....................................................................... Text
Global LFTfrm_ask As Integer, TOPfrm_ask As Integer '.............................. Position der InfoForm

'

'------------------------------------------ FORMULAR-PARAMETER ------------------------------------------

'....................................................................................... EINGABE-BEREICHE
Global FRCinp_foc As Long, BKCinp_foc As Long, BLDinp_foc As Integer '............ Aktive EingabeBereiche
Global FRCinp_nrm As Long, BKCinp_nrm As Long, BLDinp_nrm As Integer '.......... Inaktive EingabeBereiche

'................................................................................................. LISTEN
Global COLrec_lst As Long, BLDrec_lst As Integer '..................................... Daten der Records
Global COLfrm_lst As Long, BLDfrm_lst As Integer, HGHfrm_lst As Integer '.................. AuswahlRahmen
Global COLbkc_lst As Long '............................................................ ListenHintergrund
Global TOPspc_lst As Integer '............................................................... Oberer Rand
Global HGHrow_lst As Integer '............................................................. ZeilenAbstand

'............................................................................................ S1X-CONTROL
Global LFTs1x_ctr As Integer, TOPs1x_ctr As Integer '........................................... Position
Global TXTcnt_s1x As String '........................................ Bezeichner des aktuellen Wettbewrbs

'................................................................................................ CONTEST
Global LFTcnt_lst As Integer, TOPcnt_lst As Integer, NRWcnt_lst As Integer '....................... Liste
Global LFTcnt_edt As Integer, TOPcnt_edt As Integer '............................................. Editor
Global NRWimp_lst As Integer '................................................................ FileImport

'............................................................................................... STATIONS
Global StcCtr As S1X_REC_DAT '............................................................. HauptFormular
Global LFTstc_edt As Integer, TOPstc_edt As Integer '............................................. Editor
Global LFTstc_lst As Integer, TOPstc_lst As Integer, NRWstc_lst As Integer '....................... Liste
Global LFTstc_err As Integer, TOPstc_err As Integer '............................. Settings ErrorHandling

Global HRZerr_max As Integer, VTCerr_max As Integer '................... Zulssige Abweichungen der Paare
Global MINstc_duo As Integer '.............................. MindestAnzahl Paare mit gltigen Ergebnissen
Global NBRmin_max As Integer '........................ MindestAnzahl Paare fr Streichung der ExtremWerte
Global HGHerr_max As Integer '..................................... Zulssige Abweichungen der HhenWerte

Global RCTstc_hrz(99) As Integer '........................................ Werte rechter HorizontalWinkel
Global PRCstc_hrz(99) As Single '................................... Genauigkeit der horizontalen Messung
Global RCTstc_vtc(99) As Integer '.......................................... Werte rechter VertikalWinkel
Global PRCstc_vtc(99) As Single '..................................... Genauigkeit der vertikalen Messung

Global ALPstc_lnc(99) As Single '.................. Winkel zwischen StartStelle und vorheriger MeStation
Global BTAstc_lnc(99) As Single '.................... Winkel zwischen StartStelle und nchster MeStation
Global GMAstc_lnc(99) As Single '..................... VertikalWinkel zwischen MeStation und StartStelle
Global DSTstc_lnc(99) As Long '.................. Gemessene Abstnde der MeStationen zur StartStelle  [m]

Global ALPstl_bgm(99) As Double '............................. Werte ALPstc_lnc() umgerechnet in Bogenma
Global BTAstl_bgm(99) As Double '............................. Werte BTAstc_lnc() umgerechnet in Bogenma
Global GMAstl_bgm(99) As Double '............................. Werte GMAstc_lnc() umgerechnet in Bogenma

Global XXXstc_loc(99) As Double, YYYstc_loc(99) As Double, ZZZstc_loc(99) As Double '.... RaumKoordinaten
Global DSTstc_lnc_pxz(99) As Integer '....... Projektion von DSTstc_lnc() auf die Ebene des StartGelndes
Global DSTstc_stc(99, 2) As Long '........................... Abstnde zwischen benachbarten MeStationen
Global OMGstl_bgm(99) As Double '.............. Winkel zwischen AbstandsLinie zur StartStelle und Z-Achse
Global ERRomg_grd As Integer '............................................. WinkelDifferenz zum VollKreis

'............................................................ Koordinaten der Kreuzung der PeilungsLinien
Global XXXvsl_crs(99) As Double, ZZZvsl_crs(99) As Double, YYYvsl_crs(99) As Double
Global LSTstc_err As String '.......................... Liste der Stationen mit kritischen PositionsDaten
Global LSTdst_err As String '.............................. Liste der Stationen mit zu geringen Abstnden



'......................................................................................... ERGEBNIS-LISTE
Global CmpCtr As S1X_REC_DAT '............................................................. HauptFormular
Global LFTcmp_edt As Integer, TOPcmp_edt As Integer '............................................. Editor
Global LFTcmp_lod As Integer, TOPcmp_lod As Integer, NRWcmp_lod As Integer '........... WettkmpferImport

Global ALTcmp_fly(999, 3) As Long '.................................................. Altituden der Flge
Global ERRcmp_fly(999, 3) As Long '..................................................... Fehler der Flge
Global STScmp_fly(999, 3) As String '................................................... Status der Flge

Global ALTcnt_cmp(999) As Long '......................... WertungsHhen der Wettkmpfer eines Wettkampfes
Global POScnt_cmp(999) As Integer '...................... Platzierungen der Wettkmpfer eines Wettkampfes

'......................................................................................... PEILUNGS-DATEN
Global MsrCtr As S1X_REC_DAT '.............................................. Parameter des HauptFormulars

Global ALPstc_fly() As Single '............... Horizontale PeilungsWinkel der MeStationen fr einen Flug
Global GMAstc_fly() As Single '................. Vertikale PeilungsWinkel der MeStationen fr einen Flug

'.......................................................................... ERGEBNISSE DER STATIONS-PAARE
Global ClcCtr As S1X_REC_DAT '.............................................. Parameter des HauptFormulars


'----------------------------------------------- VIEWS --------------------------------------------------
Global MODv3d_s1x As Integer '............................................................ 3D-Modus (0/1)
Global KRKv3d_foc As Integer '...................... Paralaxe (Abstand der Abbildungen in der FocusTiefe)
Global COLv3d_s1x(2, 2) As Long '................................................. Farben der Abbildungen
Global D3Dmou_pnt As Integer '................................................ Paralaxe des MousePointers

'.............................................. OBSERVER ................................................
Global DSTobs_foc As Long '............................................... Entfernung Observer-FocusPunkt
Global DSTofc_pxz As Long '................................... Projektion von DSTobs_foc auf die XZ-Ebene
Global ALPobs_foc As Double '........................................................ Winkel zur YZ-Ebene
Global GMAobs_foc As Double '........................................................ Winkel zur XZ-Ebene
Global DSThrz_s1x As Long '......................................................... Abstand zum Horizont

'.............................................. STATIONS ................................................
Global IDXcnt_stc As Integer '......... Index des Wettbewerbs dessen StartGelnde zuletzt angezeigt wurde
Global NBRstc_duo As Integer '................................................ Anzahl der MestellenPaare

Global SPDimz_stc As Integer '.......................................... Anzahl Schritte StartstellenZoom
Global WDTfoc_stc As Long '................................................................... BrennWeite
Global XXXobs_stc As Double, YYYobs_stc As Double, ZZZobs_stc As Double '............... ObserverPosition
Global LFTscc_stc As Long, TOPscc_stc As Long '........ AbbildungsKoordinaten des BildschirmMittelpunktes

'............................................ MEASURE-SHOW ..............................................
Global LFTmsr_shw As Integer, TOPmsr_shw As Integer '........................................... Position

'.............................................. FLIGHTS .................................................
Global XXXfly_geo As Double, ZZZfly_geo As Double, YYYfly_geo As Double '.............. ResultKoordinaten
Global XXXobs_fly As Double, YYYobs_fly As Double, ZZZobs_fly As Double '............... ObserverPosition
Global XXXfoc_fly As Double, YYYfoc_fly As Double, ZZZfoc_fly As Double '..... RaumKoordinaten FocusPunkt
Global WDTfoc_fly As Long '................................................................... BrennWeite
Global LFTscc_fly As Long, TOPscc_fly As Long '........ AbbildungsKoordinaten des BildschirmMittelpunktes

'.............................................. MONITOR .................................................
Global CPTcnt_mnt As String '........................................ Bezeichner des aktuellen Wettbewrbs











'********************************************************************************************************
'******************************************** DRUCK S1X *************************************************
'
  Sub S1xPrint(X0&, Y0&, SCLx#)
'
'........................................................................................................

Static S1X$

  
  If S1X$ = "" Then
    FLNs1x$ = DIRhom_s1x + "\S1X.PCT"
      If Dir(FLNs1x$) = "" Then Exit Sub

    Open FLNs1x$ For Input As #99
    S1X$ = Input$(LOF(99), #99)
    Close #99
  End If

WDTx& = 3 * SCLx#
If WDTx& < 1 Then WDTx& = 1
Printer.DrawWidth = WDTx&
YY& = 0

Pq& = InStr(S1X$, "") + 2

  Do While Pq& < Len(S1X$)
    L& = 200 * (Asc(Mid$(S1X$, Pq&, 1)) - 50) + Asc(Mid$(S1X$, Pq& + 1, 1)) - 50
    PBWx$ = Mid$(S1X$, Pq& + 2, L&)
    
    Y1& = Y0& + SCLx# * YY&
      
      For P& = 1 To L& Step 4
        N$ = Mid$(PBWx$, P&, 4)
        X1& = X0& + SCLx# * (200 * (Asc(Mid$(N$, 1, 1)) - 50) + Asc(Mid$(N$, 2, 1)) - 50)
        X2& = X0& + SCLx# * (200 * (Asc(Mid$(N$, 3, 1)) - 50) + Asc(Mid$(N$, 4, 1)) - 50)
        Printer.Line (X1&, Y1&)-(X2&, Y1&)
      Next P&
    
    YY& = YY& + 15
    Pq& = Pq& + L& + 2
  Loop


'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'******************************************** ALGEMEINE STOP-TEXTE **************************************
'
  Sub S1xFrmTxtStop(IDXx%)
'
'........................................................................................................


  Select Case IDXx%
    Case 0
    
        If LCDlng_s1x = "GER" Then
          TXTmsg_stp = "Der MausZeiger steht auf keinem aktivierbaren Symbol des Formulars."
          TXTmsg_stp = TXTmsg_stp + " Wenn Sie SchaltSymbole mit der Tastatur"
          TXTmsg_stp = TXTmsg_stp + " ansteuern mchten, benutzen Sie STRG+TAB."
        Else
          TXTmsg_stp = "MousePointer is not placed on a HotSpot."
          TXTmsg_stp = TXTmsg_stp + " If You want to set the MousePointer by Keyboard,"
          TXTmsg_stp = TXTmsg_stp + " please press  [CTRL+TAB]."
        End If
      
          
    Case 101, 102
        
        If LCDlng_s1x = "GER" Then
          TXTmsg_stp = "Der MausZeiger steht auf dem FormularTitel."
          TXTmsg_stp = TXTmsg_stp + " Wenn Sie mit der Tastatur navigieren mchten, benutzen Sie"
          TXTmsg_stp = TXTmsg_stp + " ALT zusammen mit den CursorTasten."
        Else
          TXTmsg_stp = "MousePointer is placed on the header of the Window."
          TXTmsg_stp = TXTmsg_stp + " If You want to move Window by Keyboard,"
          TXTmsg_stp = TXTmsg_stp + " please press  [ALT+Left/Right/Up/Down]."
        End If
      
           
  End Select
            
'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'*************************** SCHLIESSEN VOM FORMULAREN BEI SPEICHER-FEHLERN *****************************
'
  Sub S1xMemErr()
'
'........................................................................................................


If Mid(LSTfrm_opn, 4, 1) = "*" Then Unload CLC_CTR: Exit Sub
If Mid(LSTfrm_opn, 3, 1) = "*" Then Unload MSR_CTR: Exit Sub
If Mid(LSTfrm_opn, 1, 1) = "*" Then Unload STC_CTR: Exit Sub
If Mid(LSTfrm_opn, 2, 1) = "*" Then Unload CMP_CTR: Exit Sub


'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'********************************************************************************************************
'
  Sub S1xDbsAccError(ACCx%)
'
'........................................................................................................


ERRtxt$ = Error

  If InStr(ERRtxt$, "ODBC") = 0 Then
    TXTmsg_stp = ERRtxt$
    S1X_STP.Show 1
  
  Else
    
    DBSx$ = PTHdbs_s1x: CNNx$ = DBSver_s1x
    
    On Error GoTo OpnDbsErr
    Set DBSobj_s1x = OpenDatabase(DBSx$, 0, 0, CNNx$)
    On Error GoTo 0
      
      If LCDlng_s1x = "GER" Then
          
          Select Case ACCx%
            Case 1: TXTmsg_stp = "- Die DatenErmittlung ist fehlgeschlagen -"
            Case 2: TXTmsg_stp = "- Die Daten konnten nicht aktualisiert werden -"
            Case 3: TXTmsg_stp = "- Die Daten konnten nicht hinzugefgt werden -"
            Case 4: TXTmsg_stp = "- Die Daten konnten nicht gelscht werden -"
          End Select
          
      Else
      
          Select Case ACCx%
            Case 1: TXTmsg_stp = "- Access Failed -"
            Case 2: TXTmsg_stp = "- Update Failed -"
            Case 3: TXTmsg_stp = "- Insert Failed -"
            Case 4: TXTmsg_stp = "- Remove Failed -"
          End Select
      
      End If
      
    S1X_STP.Show 1
  End If
  
                                                                                                 Exit Sub
'********************************************************************************************************
OpnDbsErr:

  If LCDlng_s1x = "GER" Then
    TXTmsg_stp = "Die S1X-DatenBank ist nicht mehr verfgbar. Wei der Geier, was Sie da angestellt haben,"
    TXTmsg_stp = TXTmsg_stp + " aber Sie knnen die Arbeit mit S1X nicht fortsetzen."
  Else
    TXTmsg_stp = "S1X-DataBase is not more available. Don't know what You done with her,"
    TXTmsg_stp = TXTmsg_stp + " but now You can not continue work in S1X."
  End If
  
S1X_STP.Show 1

Resume DbsAccErrEnd

DbsAccErrEnd:

'********************************************************************************************************
                                                                                                  End Sub




'********************************************************************************************************
'************************************ INITIALISIEREN DES SCROLL-POINTERS ********************************
'
  Sub S1xFrmIniScrBar(OBJfrm_s1x, NBRrec%, NBRrow%, NBRscr%)
'
'
'                                                 |X|             HH - Lnge des ScrollBars
'                                                 |X|HP           HP - Lnge des Pointers
'                                                 |X|            NRC - Anzahl Records der Liste
'                                                 |X|            NRW - Anzahl Zeilen des Fensters
'                                                 | |
'                                                 | |
'                                              HH | |
'                                                 | |
'                                                 | |
'
'    Der Pointer soll so initialisiert werden, da das Verhltnis der Hhen Pointers zur Hhe
'    des ScrollBars dem Verhltnis der Anzahl Zeilen des Fenster zur Anzahl aller Records entspricht.
'
'                   HP / HH = NRW / NRC
'                        HP = NRW * HH / NRC
'
'........................................................................................................


RECscr% = NBRrec% - NBRrow% '........................................... Anzahl scrollbarer Records
  If RECscr% < 1 Then OBJfrm_s1x.ScrBarPct.Visible = 0: Exit Sub


OBJfrm_s1x.ScrBarPct.Left = OBJfrm_s1x.RecLstPct.Left - OBJfrm_s1x.ScrBarPct.Width - 90
OBJfrm_s1x.ScrBarPct.Top = OBJfrm_s1x.RecLstPct.Top + 15
OBJfrm_s1x.ScrBarPct.Height = OBJfrm_s1x.RecLstPct.Height - 15
OBJfrm_s1x.ScrBarPct.BackColor = OBJfrm_s1x.BackColor

HGHpnt% = OBJfrm_s1x.ScrBarPct.Height * (NBRrow% / NBRrec%)
If HGHpnt% < OBJfrm_s1x.ScrPntPct.Width Then HGHpnt% = OBJfrm_s1x.ScrPntPct.Width

OBJfrm_s1x.ScrPntPct.Top = 0
OBJfrm_s1x.ScrPntPct.Height = HGHpnt%

S1xFrmSetScrPointer OBJfrm_s1x, NBRrec%, NBRrow%, NBRscr%
S1xFrmDrwScrPointer OBJfrm_s1x, 0
OBJfrm_s1x.ScrBarPct.Visible = 1


'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub S1xFrmDrwScrPointer(OBJfrm_s1x, SETx%)
'
'........................................................................................................

WDTx% = OBJfrm_s1x.ScrPntPct.Width - 15
HGHx% = OBJfrm_s1x.ScrPntPct.Height - 15

  Select Case SETx%

    Case 0
      OBJfrm_s1x.ScrPntPct.BackColor = &HC0C0C0
      OBJfrm_s1x.ScrPntPct.Line (0, 0)-(WDTx%, 0), &H808080
      OBJfrm_s1x.ScrPntPct.Line (0, 0)-(0, HGHx%), &H808080
      OBJfrm_s1x.ScrPntPct.Line (15, HGHx%)-(WDTx%, HGHx%), &HFFFFFF
      OBJfrm_s1x.ScrPntPct.Line (WDTx%, HGHx%)-(WDTx%, 0), &HFFFFFF

    Case 1
      OBJfrm_s1x.ScrPntPct.BackColor = &HC0C0C0
      OBJfrm_s1x.ScrPntPct.Line (0, 0)-(WDTx%, 0), &HFFFFFF
      OBJfrm_s1x.ScrPntPct.Line (0, 0)-(0, HGHx%), &HFFFFFF
      OBJfrm_s1x.ScrPntPct.Line (15, HGHx%)-(WDTx%, HGHx%), &H808080
      OBJfrm_s1x.ScrPntPct.Line (WDTx%, HGHx%)-(WDTx%, 0), &H808080
      OBJfrm_s1x.ScrPntPct.MousePointer = 1

    Case 2
      'OBJfrm_s1x.ScrPntPct.BackColor = &HFF0000
      'OBJfrm_s1x.ScrPntPct.Line (0, 0)-(WDTx%, 0), &HFFFF00
      'OBJfrm_s1x.ScrPntPct.Line (0, 0)-(0, HGHx%), &HFFFF00
      'OBJfrm_s1x.ScrPntPct.Line (15, HGHx%)-(WDTx%, HGHx%), &H800000
      'OBJfrm_s1x.ScrPntPct.Line (WDTx%, HGHx%)-(WDTx%, 0), &H800000
  
      'OBJfrm_s1x.ScrPntPct.PSet (WDTx%, 0), &HC0C0C0
      'OBJfrm_s1x.ScrPntPct.PSet (0, HGHx%), &HC0C0C0

      OBJfrm_s1x.ScrPntPct.MousePointer = 99

  End Select

'********************************************************************************************************
                                                                                                  End Sub





'********************************************************************************************************
'********************* SETZEN DES SCROLL-POINTERS NACH DER ANZAHL GESCROLLTER RECORDS *******************
'
  Sub S1xFrmSetScrPointer(OBJfrm_s1x, NBRrec%, NBRrow%, NBRscr%)
'
'
'                                                 | |             HH - Lnge des ScrollBars
'                                                 | | T           HP - Lnge des Pointers
'                                                 | |            NRC - Anzahl Records der Liste
'                                            TOPx |X|            NRS - Anzahl gescrollter Records
'                                                 |X|HP          NRW - Anzahl Zeilen des Fensters
'                                                 |X|
'                                              HH | |
'                                                 | | D
'                                                 | |
'
'    Der Pointer soll so positioniert werden, da das Verhltnis der Strecke T vom oberen Rand des
'    Pointers zum oberen Rand des ScrollBars zur Strecke D vom unteren Rand des Pointers zum
'    unteren Rand des ScrollBars dem Verhltnis der Anzahl Records "ber" dem Fenster zur Anzahl
'    Records "unter" dem Fenster entspricht.
'
'                   T/D = TOPx/(HH - TOPx - HP) = NRS/(NRC + 1 - NRS - NRW)
'                  TOPx * (NRC + 1 - NRS - NRW) = (HH - TOPx - HP) * NRS
'  TOPx * NRC + TOPx - TOPx * NRS - TOPx * NRW) = NRS * HH - NRS * TOPx - NRS * HP
'                    ~~~~~~~~~~~~                          ~~~~~~~~~~~~
'                        TOPx * (NRC + 1 - NRW) = NRS * (HH - HP)
'                                         TOPx  = NRS * (HH - HP) / (NRC + 1 - NRW)
'
'........................................................................................................


RECrmn% = NBRrec% + 1 - NBRrow%
  If RECrmn% < 1 Then OBJfrm_s1x.ScrBarPct.Visible = 0: Exit Sub
  
TOPx& = NBRscr% * (OBJfrm_s1x.ScrBarPct.Height - OBJfrm_s1x.ScrPntPct.Height) / RECrmn%

  If TOPx& < 0 Then TOPx& = 0
    If TOPx& > OBJfrm_s1x.ScrBarPct.Height - OBJfrm_s1x.ScrPntPct.Height Then
      TOPx& = OBJfrm_s1x.ScrBarPct.Height - OBJfrm_s1x.ScrPntPct.Height
    End If
    
OBJfrm_s1x.ScrPntPct.Top = TOPx&

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'********************************************************************************************************
'
  Sub S1xFrmMove(OBJfrm_s1x, KEYx%, CTRx%)
'
'........................................................................................................

S1X_DMY.Hide
DoEvents

  Select Case CTRx%
    Case 4 '......................................................................................... ALT
      DPSx% = 60
    Case 5 '..................................................................................... SFT+ALT
      DPSx% = 240
    Case 6 '..................................................................................... CTR+ALT
      DPSx% = 15
    Case Else
      Exit Sub
  End Select
      
LFTfrm% = OBJfrm_s1x.Left: TOPfrm% = OBJfrm_s1x.Top
WDTfrm% = OBJfrm_s1x.Width: HGHfrm% = OBJfrm_s1x.Height
GetCursorPos APIpos

LFTnew% = LFTfrm%: TOPnew% = TOPfrm%
      
  Select Case KEYx%
    Case 9
      Exit Sub
    
    Case 18 '........................................................................................ Alt
      XX& = 15 * APIpos.X: YY& = 15 * APIpos.Y
        
        If XX& < LFTfrm% Or XX& > LFTfrm% + WDTfrm% Or YY& < TOPfrm% Or YY& > TOPfrm% + HGHfrm% Then
          XX& = (LFTfrm% + 450) / 15: YY& = (TOPfrm% + 390) / 15
          SetCursorPos XX&, YY&
        End If
        
      Exit Sub
    
    Case 37 '....................................................................................... Left
      LFTnew% = LFTfrm% - DPSx%: If LFTnew% < 0 Then LFTnew% = 0
        
    Case 39 '...................................................................................... Right
      LFTnew% = LFTfrm% + DPSx%
      If LFTnew% + WDTfrm% > Screen.Width Then LFTnew% = Screen.Width - WDTfrm%

    Case 38 '......................................................................................... Up
      TOPnew% = TOPfrm% - DPSx%: If TOPnew% < 0 Then TOPnew% = 0
    
    Case 40 '......................................................................................... Dn
      TOPnew% = TOPfrm% + DPSx%
      If TOPnew% + HGHfrm% > Screen.Height Then TOPnew% = Screen.Height - HGHfrm%

    Case 115 '........................................................................................ F4
      Unload OBJfrm_s1x
      Exit Sub
      
    Case Else
      Exit Sub
  End Select
      
      
  If LFTnew% <> LFTfrm% Or TOPnew% <> TOPfrm% Then
    SetCursorPos APIpos.X + (LFTnew% - LFTfrm%) / 15, APIpos.Y + (TOPnew% - TOPfrm%) / 15
    OBJfrm_s1x.Move LFTnew%, TOPnew%
  End If

KEYx% = 0

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'************************************ FFNEN DER S1X-DATENBANK ******************************************
'
  Sub S1xDbsConnect()
'
'........................................................................................................

'.............................................................................. Verzeichnis der Datenbank
If Right(PTHdbs_s1x, 1) = "\" Then PTHdbs_s1x = Left(PTHdbs_s1x, Len(PTHdbs_s1x) - 1)
  
If PTHdbs_s1x = "" Then PTHdbs_s1x = DIRhom_s1x + "\DATA"
  

  If Left(PTHdbs_s1x, 1) < "C" Then
    TXTmsg_stp = "Can not work with DataBase on temporary Drive  [" + Left(PTHdbs_s1x, 1) + "]."
    S1X_STP.Show 1
    
    Exit Sub
  End If

  
  On Error GoTo DbsDrvErr: ChDrive Left(PTHdbs_s1x, 1)

DbsVerDirectory:
  On Error GoTo DbsDirErr: ChDir PTHdbs_s1x

DbsVerDefDirectory:
  On Error GoTo DbsHomErr: ChDir PTHdbs_s1x
  
DbsVerAccess:
  FLNqqq$ = PTHdbs_s1x + "\QQQ.DIR"
  On Error GoTo DbsWrtErr: Open FLNqqq$ For Output As #99: PTHx% = 3: Close #99: Kill FLNqqq$

On Error GoTo 0
      
DBSx$ = PTHdbs_s1x: CNNx$ = DBSver_s1x

'CNNx$ = "dbase iv"
'CNNx$ = "dBASE 5.0"

'........................................................................................... ODBC-Connect
On Error GoTo OpnDbsErr
Set DBSobj_s1x = OpenDatabase(DBSx$, 0, 0, CNNx$)
On Error GoTo 0


'........................................................................................ Datenbank-Files
TBLfnd% = 0
FLNtbl$ = "S1X_CNT.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1
FLNtbl$ = "S1X_STC.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1
FLNtbl$ = "S1X_MSR.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1
FLNtbl$ = "S1X_CLC.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1
FLNtbl$ = "S1X_FLY.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1
FLNtbl$ = "S1X_CMP.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1
FLNtbl$ = "S1X_LCD.DBF": If Dir(PTHdbs_s1x + "\" + FLNtbl$) > "" Then TBLfnd% = TBLfnd% + 1


  Select Case TBLfnd%
    Case 0
      S1xFrmInfText S1X_CTR, "Creating New DataBase ..."

      S1xDbsCreate
      TXTmsg_stp = "S1X-DataBase not found."
      TXTmsg_stp = TXTmsg_stp + " An empty S1X-DataBase was created in  [" + PTHdbs_s1x + "]."
      S1X_STP.Show 1
      DBScnn_s1x = 1
      IDXcnt_s1x = 0
    Case 7
      QRYx$ = "SELECT * FROM s1x_cnt WHERE cnt_index > 0 "
      Set CRSobj_s1x = DBSobj_s1x.OpenRecordset(QRYx$, 2, 4)
        
        If Not CRSobj_s1x.EOF Then
          DBScnn_s1x = 2
        Else
          DBScnn_s1x = 1
        End If
      
      On Error Resume Next: CRSobj_s1x.Close: On Error GoTo 0
      
    Case Else
      TXTmsg_stp = "S1X-DataBase in  [" + PTHdbs_s1x + "]  is corrupt. Please copy your DataBase-BackUp"
      TXTmsg_stp = TXTmsg_stp + " to this Directory or delete all Files with Extension 'DBF' and start again."
      S1X_STP.Show 1
      
  End Select


  
                                                                                                 Exit Sub
'********************************************************************************************************
'--------------------------------------------------------------------------------------------------------
DbsDrvErr:
On Error GoTo 0
TXTmsg_stp = "Drive  [" + Left(PTHdbs_s1x, 1) + "]  for DataBase Access not available."
TXTmsg_stp = TXTmsg_stp + " Will Continue with S1X-HomeDrive  [" + Left(DIRhom_s1x, 1) + "]."
S1X_STP.Show 1

PTHdbs_s1x = DIRhom_s1x
Resume DbsVerDirectory

'--------------------------------------------------------------------------------------------------------
DbsDirErr:
On Error GoTo 0

  If Not PTHdbs_s1x = DIRhom_s1x + "\DATA" Then
    TXTmsg_stp = "Path for S1X-DataBase  [" + PTHdbs_s1x + "]  not found."
    TXTmsg_stp = TXTmsg_stp + " Will Continue with S1X-DefaultDirectory  [" + DIRhom_s1x + "\DATA]."
    S1X_STP.Show 1
    
    PTHdbs_s1x = DIRhom_s1x + "\DATA"
  End If
  
Resume DbsVerDefDirectory

'--------------------------------------------------------------------------------------------------------
DbsHomErr:
On Error GoTo 0

MkDir PTHdbs_s1x
Resume DbsVerAccess

'--------------------------------------------------------------------------------------------------------
DbsWrtErr:
On Error GoTo 0

TXTmsg_stp = "Directory for S1X-DataBase  [" + PTHdbs_s1x + "]  is write-protected for this User."
TXTmsg_stp = TXTmsg_stp + " Can not open S1X-DataBase!"
S1X_STP.Show 1

Resume DbsOpnEnd

'--------------------------------------------------------------------------------------------------------
OpnDbsErr:
On Error GoTo 0

TXTmsg_stp = Error
S1X_STP.Show 1

Resume DbsOpnEnd

'--------------------------------------------------------------------------------------------------------
DbsIdxErr:

TXTmsg_stp = "Index for Table  [" + DBSidx$ + "]  in S1X-DataBase not set."
TXTmsg_stp = TXTmsg_stp + " Please copy your DataBase-BackUp"
TXTmsg_stp = TXTmsg_stp + " to the Directory  [" + PTHdbs_s1x + "]  and start again."
S1X_STP.Show 1

'--------------------------------------------------------------------------------------------------------
DbsOpnEnd:

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'**************************************** INITIALISIEREN DER DATENBANK **********************************
'
  Sub S1xDbsCreate()
'                                    FELD-TYPEN: 1=Boolean, 3=Integer, 4=Long, 6=Single, 8=Datum, 10=Text
'........................................................................................................


Dim DBStbl_obj As TableDef, DBSclm_obj As Field, DBSidx_obj As Index '........... InitialisierungsObjekte


'............................................................................................... CONTESTS
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "s1x_cnt": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("s1x_cnt")

Set DBSclm_obj = DBStbl_obj.CreateField("cnt_index", 3):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("titel", 10, 64):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("location", 10, 64):  DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("date", 8):           DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("category", 10, 32):  DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("director", 10, 32):  DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("jury", 10, 32):      DBStbl_obj.Fields.Append DBSclm_obj

Set DBSclm_obj = DBStbl_obj.CreateField("hrz_err", 3):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("vtc_err", 3):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("min_duo", 3):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("nbr_ign", 3):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hgh_err", 3):        DBStbl_obj.Fields.Append DBSclm_obj

Set DBSclm_obj = DBStbl_obj.CreateField("xxx_obs", 4):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("zzz_obs", 4):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("yyy_obs", 4):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("wdt_foc", 6):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("lft_scc", 6):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("top_scc", 6):        DBStbl_obj.Fields.Append DBSclm_obj

Set DBSclm_obj = DBStbl_obj.CreateField("div_001", 1):        DBStbl_obj.Fields.Append DBSclm_obj
DBSobj_s1x.TableDefs.Append DBStbl_obj


Set DBSidx_obj = DBStbl_obj.CreateIndex("cnt_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cnt_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("titel")
Set DBSclm_obj = DBSidx_obj.CreateField("titel")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("date")
Set DBSclm_obj = DBSidx_obj.CreateField("date")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj


'......................................................................................... MESS-STATIONEN
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "S1X_STC": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("S1X_STC")

Set DBSclm_obj = DBStbl_obj.CreateField("cnt_index", 3):    DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("stc_index", 3):    DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("stc_typ", 10, 10): DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hrz_rct", 3):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hrz_prc", 6):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("vtc_rct", 3):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("vtc_prc", 6):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("lft_stc", 6):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("rgt_stc", 6):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("vtc_lnc", 6):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("dst_lnc", 3):      DBStbl_obj.Fields.Append DBSclm_obj
DBSobj_s1x.TableDefs.Append DBStbl_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cnt_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cnt_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("stc_index")
Set DBSclm_obj = DBSidx_obj.CreateField("stc_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj


'......................................................................................... PEILUNGS-DATEN
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "S1X_MSR": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("S1X_MSR")

Set DBSclm_obj = DBStbl_obj.CreateField("cnt_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("cmp_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("fly_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("stc_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hrz_angle", 6):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("vtc_angle", 6):     DBStbl_obj.Fields.Append DBSclm_obj

DBSobj_s1x.TableDefs.Append DBStbl_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cnt_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cnt_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cmp_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cmp_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("fly_index")
Set DBSclm_obj = DBSidx_obj.CreateField("fly_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("stc_index")
Set DBSclm_obj = DBSidx_obj.CreateField("stc_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

'.......................................................................... ERGEBNISSE DER STATIONS-PAARE
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "S1X_CLC": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("S1X_CLC")

Set DBSclm_obj = DBStbl_obj.CreateField("cnt_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("cmp_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("fly_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("st1_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("st2_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hgh", 3):           DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hrz_err", 3):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("vtc_err", 3):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("sts", 10, 2):       DBStbl_obj.Fields.Append DBSclm_obj

DBSobj_s1x.TableDefs.Append DBStbl_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cnt_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cnt_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cmp_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cmp_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("fly_index")
Set DBSclm_obj = DBSidx_obj.CreateField("fly_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

'................................................................................... ERGEBNISSE DER FLGE
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "S1X_FLY": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("S1X_FLY")

Set DBSclm_obj = DBStbl_obj.CreateField("cnt_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("cmp_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("fly_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("xxx", 3):           DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("zzz", 3):           DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("hgh", 3):           DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("err", 3):           DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("sts", 10, 2):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("xxx_obs", 4):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("zzz_obs", 4):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("yyy_obs", 4):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("wdt_foc", 6):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("lft_scc", 6):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("top_scc", 6):       DBStbl_obj.Fields.Append DBSclm_obj
DBSobj_s1x.TableDefs.Append DBStbl_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cnt_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cnt_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cmp_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cmp_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj


'......................................................................... WETTKMPFER UND END-ERGEBNISSE
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "S1X_CMP": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("S1X_CMP")

Set DBSclm_obj = DBStbl_obj.CreateField("cnt_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("cmp_index", 3):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("name", 10, 32):     DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("name_add", 10, 10): DBStbl_obj.Fields.Append DBSclm_obj

Set DBSclm_obj = DBStbl_obj.CreateField("result", 3):        DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("place", 3):         DBStbl_obj.Fields.Append DBSclm_obj
DBSobj_s1x.TableDefs.Append DBStbl_obj


Set DBSidx_obj = DBStbl_obj.CreateIndex("cnt_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cnt_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("cmp_index")
Set DBSclm_obj = DBSidx_obj.CreateField("cmp_index")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("name")
Set DBSclm_obj = DBSidx_obj.CreateField("name")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

'........................................................................................... LNDER-CODES
On Error Resume Next: DBSobj_s1x.TableDefs.Delete "S1X_LCD": On Error GoTo 0
Set DBStbl_obj = DBSobj_s1x.CreateTableDef("S1X_LCD")

Set DBSclm_obj = DBStbl_obj.CreateField("lcd", 10, 3):       DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("ger", 10, 32):      DBStbl_obj.Fields.Append DBSclm_obj
Set DBSclm_obj = DBStbl_obj.CreateField("eng", 10, 32):      DBStbl_obj.Fields.Append DBSclm_obj
DBSobj_s1x.TableDefs.Append DBStbl_obj

Set DBSidx_obj = DBStbl_obj.CreateIndex("lcd")
Set DBSclm_obj = DBSidx_obj.CreateField("lcd")
DBSidx_obj.Fields.Append DBSclm_obj: DBStbl_obj.Indexes.Append DBSidx_obj

INSx$ = "INSERT INTO s1x_lcd (lcd,ger,eng) VALUES ("
DBSobj_s1x.Execute INSx$ + "'CHN','China','China')"
DBSobj_s1x.Execute INSx$ + "'CZE','Tschechien','Czech Republik')"
DBSobj_s1x.Execute INSx$ + "'ESP','Spanien','Spain')"
DBSobj_s1x.Execute INSx$ + "'GBR','Grobritannien','United Kingdom')"
DBSobj_s1x.Execute INSx$ + "'GER','Deutschland','Germany')"
DBSobj_s1x.Execute INSx$ + "'ITA','Italien','Italy')"
DBSobj_s1x.Execute INSx$ + "'LAT','Estland','Latvia')"
DBSobj_s1x.Execute INSx$ + "'LTU','Litauen','Lithunia')"
DBSobj_s1x.Execute INSx$ + "'MAC','Mazedonien','Macedonia')"
DBSobj_s1x.Execute INSx$ + "'NED','Niederlande','Netherlands')"
DBSobj_s1x.Execute INSx$ + "'POL','Polen','Poland')"
DBSobj_s1x.Execute INSx$ + "'ROM','Rumnien','Romania')"
DBSobj_s1x.Execute INSx$ + "'RUS','Russland','Russia')"
DBSobj_s1x.Execute INSx$ + "'SLO','Slovenien','Slovenia')"
DBSobj_s1x.Execute INSx$ + "'SVK','Slovakei','Slovakia')"
DBSobj_s1x.Execute INSx$ + "'UKR','Ukraine','Ukraine')"
DBSobj_s1x.Execute INSx$ + "'USA','Vereinigte Staaten von Amerika','U.S.A')"
DBSobj_s1x.Execute INSx$ + "'YUG','Jugoslawien','Yugoslavia')"

DBScnn_s1x = 1

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'***************************************** AUSGABE QUICK-INFO *******************************************
'
  Sub S1xFrmInfText(OBJfrm_s1x, TXTx$)
'
'........................................................................................................


X1% = 15: Y1% = 15
X2% = OBJfrm_s1x.InfPnlPct.Width - 30: Y2% = OBJfrm_s1x.InfPnlPct.Height - 30

CC& = OBJfrm_s1x.InfPnlPct.BackColor
OBJfrm_s1x.InfPnlPct.Line (15, 15)-(X2%, Y2%), CC&, BF

OBJfrm_s1x.InfPnlPct.CurrentX = 120
OBJfrm_s1x.InfPnlPct.CurrentY = 45
OBJfrm_s1x.InfPnlPct.Print TXTx$;

OBJfrm_s1x.InfPnlPct.Refresh

'********************************************************************************************************
                                                                                                  End Sub

'********************************************************************************************************
'************************************** INITIALISIEREN DER INFO-LEISTE **********************************
'
  Sub S1xFrmInfPanel(OBJfrm_s1x)
'
'........................................................................................................


OBJfrm_s1x.InfPnlPct.BackColor = OBJfrm_s1x.BackColor
LFTx% = 120: TOPx% = OBJfrm_s1x.Height - 390
WDTx% = OBJfrm_s1x.Width - 240: HGHx% = 300
OBJfrm_s1x.InfPnlPct.Move LFTx%, TOPx%, WDTx%, HGHx%

C1& = &HFFFFFF: C2& = &H808080
OBJfrm_s1x.InfPnlPct.Line (0, 0)-(WDTx% - 15, HGHx% - 15), C1&, B
OBJfrm_s1x.InfPnlPct.Line (0, 0)-(WDTx% - 15, 0), C2&
OBJfrm_s1x.InfPnlPct.Line (0, 0)-(0, HGHx% - 15), C2&, B

'********************************************************************************************************
                                                                                                  End Sub


'========================================================================================================
'============================== PRFUNG VON WERTEN AUF UNZULSSIGE ZEICHEN ==============================
'
  Function S1xFmtVerCharacter%(VALx$, LSTchr$, LSTloc%)
'
'........................................................................................................


S1xFmtVerCharacter% = 0

  If LSTloc% = 0 Then '................ NegativListe (kein Zeichen in VALx darf in LSTchr enthalten sein)
      
      For PP% = 1 To Len(VALx$)
        QQ$ = Mid(VALx$, PP%, 1)
          
          If InStr(LSTchr$, QQ$) > 0 Then
            TXTmsg_stp = "Invalid Character"
            S1xFmtVerCharacter% = PP%
            Exit Function
          End If
      
      Next PP%
  
  Else '............................... PositivListe (jedes Zeichen in VALx mu in LSTchr enthalten sein)
      
      For PP% = 1 To Len(VALx$)
        QQ$ = Mid(VALx$, PP%, 1)
          
          If InStr(LSTchr$, QQ$) = 0 Then
            TXTmsg_stp = "Invalid Character"
            S1xFmtVerCharacter% = PP%
            Exit Function
          End If
      
      Next PP%
  
  End If
  
'========================================================================================================
                                                                                             End Function


'********************************************************************************************************
'************************************ EINBLENDEN EINES FORMULARS ****************************************
'
  Sub S1xFrmZoomIn(OBJfrm_s1x, LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%)
'
'........................................................................................................

OBJfrm_s1x.Cls
OBJfrm_s1x.AutoRedraw = 0
  
GetCursorPos APIpos: XX& = 15 * APIpos.X: YY& = 15 * APIpos.Y '......................... QuellKoordinaten

LFTtmp% = XX&: TOPtmp% = YY&: WDTtmp% = 0: HGHtmp% = 0 '............................. FormularKoordinaten

OBJfrm_s1x.Move LFTtmp%, TOPtmp%, WDTtmp%, HGHtmp%: OBJfrm_s1x.Show: DoEvents
OBJfrm_s1x.AutoRedraw = 0

      
NN& = S1Xzom_stp / (CLng(WDTfrm%) * HGHfrm%)
If NN& < 10 Then NN& = 10

DW# = WDTfrm% / NN&: DH# = HGHfrm% / NN&
DX# = (XX& - LFTfrm% - 0.5 * WDTfrm%) / NN& + DW# / 2
DY# = (YY& - TOPfrm% - 0.5 * HGHfrm%) / NN& + DH# / 2
C0& = OBJfrm_s1x.BackColor: C1& = &HFFFFFF: C2& = &H808080
T# = Timer

  For N& = 1 To NN&
    OBJfrm_s1x.Line (0, 0)-(WDTtmp% - 15, HGHtmp% - 15), C0&, B
          
    LFTtmp% = LFTtmp% - DX#: TOPtmp% = TOPtmp% - DY#
    WDTtmp% = WDTtmp% + DW#: If WDTtmp% > WDTfrm% Then WDTtmp% = WDTfrm%
    HGHtmp% = HGHtmp% + DH#: If HGHtmp% > HGHfrm% Then HGHtmp% = HGHfrm%
    OBJfrm_s1x.Move LFTtmp%, TOPtmp%, WDTtmp%, HGHtmp%
              
    OBJfrm_s1x.Line (0, 0)-(WDTtmp% - 15, HGHtmp% - 15), 0, B
    OBJfrm_s1x.Refresh: DoEvents
  Next N&

OBJfrm_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%
T# = Timer - T#
If T# > 0 Then S1Xzom_stp = 0.7 * S1Xzom_stp / T# Else S1Xzom_stp = 10 * S1Xzom_stp

'................................................................................................. Border
OBJfrm_s1x.AutoRedraw = 1

OBJfrm_s1x.DrawWidth = 2
C1& = &HFFFFFF: C2& = &H808080
OBJfrm_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), C1&, B
OBJfrm_s1x.Line (15, HGHfrm% - 15)-(WDTfrm% - 15, HGHfrm% - 15), C2&
OBJfrm_s1x.Line (WDTfrm% - 15, 30)-(WDTfrm% - 15, HGHfrm% - 15), C2&

OBJfrm_s1x.DrawWidth = 1
OBJfrm_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), 0, B
OBJfrm_s1x.PSet (15, HGHfrm% - 15), C2&
OBJfrm_s1x.PSet (WDTfrm% - 15, 15), C2&
    
  
'********************************************************************************************************
                                                                                                  End Sub



'********************************************************************************************************
'************************************ AUSBLENDEN EINES FORMULARS ****************************************
'
  Sub S1xFrmZoomOut(OBJfrm_s1x, XX&, YY&)
'
'........................................................................................................


LFTfrm# = OBJfrm_s1x.Left:  TOPfrm# = OBJfrm_s1x.Top
WDTfrm# = OBJfrm_s1x.Width: HGHfrm# = OBJfrm_s1x.Height

OBJfrm_s1x.Line (0, 0)-(WDTfrm#, HGHfrm#), OBJfrm_s1x.BackColor, BF
DoEvents

OBJfrm_s1x.AutoRedraw = 0
S1X_DMY.Hide
DoEvents
      
If OBJfrm_s1x.Enabled = 1 Then OBJfrm_s1x.SetFocus
      
NN& = S1Xzom_stp / (WDTfrm# * HGHfrm#)
If NN& = 0 Then NN& = 1
      
  If XX& + YY& = 0 Then '................................................... Ausblenden auf FormularMitte
    ROT& = 192: GRN& = 192: BLU& = 192
    CDG& = 1 + Int(192 / NN&)
  
      If WDTfrm# > HGHfrm# Then
        DS# = WDTfrm# / NN&: DP# = 0.5 * DS#
      
          Do While HGHfrm# > DS#
            LFTfrm# = LFTfrm# + DP#: TOPfrm# = TOPfrm# + DP#
            WDTfrm# = WDTfrm# - DS#: HGHfrm# = HGHfrm# - DS#
            OBJfrm_s1x.Move LFTfrm#, TOPfrm#, WDTfrm#, HGHfrm#
            
            ROT& = ROT& - CDG&: GRN& = GRN& - CDG&: BLU& = BLU& - CDG&
            If Not ROT& < 0 Then OBJfrm_s1x.BackColor = ROT& + GRN& * 256 + BLU& * 256 * 256
            
            OBJfrm_s1x.Line (0, 0)-(WDTfrm# - 15, HGHfrm# - 15), &H808080, B
            DoEvents
          Loop
      
      Else
        DS# = HGHfrm# / NN&: DP# = 0.5 * DS#
      
          Do While WDTfrm# > DS#
            LFTfrm# = LFTfrm# + DP#: TOPfrm# = TOPfrm# + DP#
            WDTfrm# = WDTfrm# - DS#: HGHfrm# = HGHfrm# - DS#
            OBJfrm_s1x.Move LFTfrm#, TOPfrm#, WDTfrm#, HGHfrm#
            OBJfrm_s1x.Line (0, 0)-(WDTfrm# - 15, HGHfrm# - 15), &H808080, B
            DoEvents
          Loop
       
      End If

  Else '................................................................... Ausblenden auf XX-YY-Position
    DW! = WDTfrm# / NN&: DH! = HGHfrm# / NN&
    DX! = (XX& - LFTfrm# - 0.5 * WDTfrm#) / NN& + DW! / 2
    DY! = (YY& - TOPfrm# - 0.5 * HGHfrm#) / NN& + DH! / 2

   
      For N& = 1 To NN&
        LFTfrm# = LFTfrm# + DX!: TOPfrm# = TOPfrm# + DY!
        WDTfrm# = WDTfrm# - DW!: If WDTfrm# < 0 Then WDTfrm# = 0
        HGHfrm# = HGHfrm# - DH!: If HGHfrm# < 0 Then HGHfrm# = 0
        OBJfrm_s1x.Move LFTfrm#, TOPfrm#, WDTfrm#, HGHfrm#
        OBJfrm_s1x.Line (0, 0)-(WDTfrm# - 15, HGHfrm# - 15), &H808080, B
        DoEvents
      Next N&

  End If
  
OBJfrm_s1x.Hide
DoEvents
    
  
'********************************************************************************************************
                                                                                                  End Sub

'========================================================================================================
'========================================================================================================
'
   Function S1xFmtDtmMnt$(DTMx$)
'
'........................................................................................................
   
DTMfrm$ = LTrim$(Str$(Val(Left$(DTMx$, 2)))) + ". "

MM% = Val(Mid$(DTMx$, 4, 2))
  
  Select Case MM%
    Case 1: DTMfrm$ = DTMfrm$ + "Januar"
    Case 2: DTMfrm$ = DTMfrm$ + "Februar"
    Case 3: DTMfrm$ = DTMfrm$ + "Mrz"
    Case 4: DTMfrm$ = DTMfrm$ + "April"
    Case 5: DTMfrm$ = DTMfrm$ + "Mai"
    Case 6: DTMfrm$ = DTMfrm$ + "Juni"
    Case 7: DTMfrm$ = DTMfrm$ + "Juli"
    Case 8: DTMfrm$ = DTMfrm$ + "August"
    Case 9: DTMfrm$ = DTMfrm$ + "September"
    Case 10: DTMfrm$ = DTMfrm$ + "Oktober"
    Case 11: DTMfrm$ = DTMfrm$ + "November"
    Case 12: DTMfrm$ = DTMfrm$ + "Dezember"
  End Select
    
DTMfrm$ = DTMfrm$ + " " + Right$(DTMx$, 4)
S1xFmtDtmMnt$ = DTMfrm$

'========================================================================================================
                                                                                             End Function

'========================================================================================================
'========================================= FORMATIEREN VON EINGABE-WERTEN ===============================
'
  Function S1xFmtInpValue$(VALx$, FMTx$)
'
'........................................................................................................


VALsav$ = Trim(VALx$)
VALfmt$ = VALsav$
S1xFmtInpValue$ = VALfmt$

  Select Case Left(FMTx$, 3)
    Case "DTM" '................................................................................... DATUM
      On Error GoTo DtmErr
      DTM = DateValue(VALsav$)
      On Error GoTo 0
      
    Case "NBR" '.................................................................................. ZAHLEN
     
        Select Case Mid(FMTx$, 6, 1)
          Case "_" '............................................................................ GanzZahl
          
                If S1xFmtVerCharacter%(VALsav$, "0123456789", 1) <> 0 Then Exit Function

            LENmax% = Val(Mid(FMTx$, 5, 1))
              If Len(VALfmt$) > LENmax% Then TXTmsg_stp = "Overflow": Exit Function
          
            If Mid(FMTx$, 7, 1) = "0" Then VALfmt$ = String(LENmax% - Len(VALfmt$), "0") + VALfmt$
          
          Case "," '......................................................................... DezimalZahl
              
                If S1xFmtVerCharacter%(VALsav$, "-0123456789.,", 1) <> 0 Then Exit Function

            Pq% = InStr(VALsav$, ",")
            If Pq% > 0 Then Mid(VALsav$, Pq%, 1) = "."
          
            VALsav$ = LTrim(Str(Val(VALsav$)))
            Pq% = InStr(VALsav$, ".")
              If Pq% = 0 Then VALsav$ = VALsav$ + ".": Pq% = Len(VALsav$)
            
            LENint% = Val(Mid(FMTx$, 5, 1))
                
                If Val(VALsav$) < 0 Then
                  If Pq% - 2 > LENint% Then TXTmsg_stp = "Overflow": Exit Function
                Else
                  If Pq% - 1 > LENint% Then TXTmsg_stp = "Overflow": Exit Function
                End If
                
            If Pq% = 1 Then VALsav$ = "0" + VALsav$: Pq% = 2
              
            LENdec% = Val(Mid(FMTx$, 7, 1))
              If Pq% < Len(VALsav$) - LENdec% Then TXTmsg_stp = "Overflow": Exit Function
              
            VALfmt$ = VALsav$ + String(LENdec% - Len(VALsav$) + Pq%, "0")
            If LCDlng_s1x = "GER" Then Mid(VALfmt$, Pq%, 1) = ","
            
        End Select


    
    Case "NAM" '................................................................................... NAMEN
      If S1xFmtVerCharacter%(VALsav$, "0123456789/:;+><=(){}@", 0) <> 0 Then Exit Function
    
    Case "LOV" '.................................................................................. Lizenz
  
      Select Case Right(FMTx$, 3)
        Case "RCT"
          If S1xFmtVerCharacter%(VALsav$, "0123456789,.", 1) <> 0 Then Exit Function
        
        VALfmt$ = LTrim(Str(Val(VALsav$)))
          
          If Not (VALfmt$ = "90" Or VALfmt$ = "100") Then
            TXTmsg_stp = "Unknown RectangleValue": Exit Function
            Exit Function
          End If
          
      End Select
      
    Case "LIC" '.................................................................................. Lizenz
    
    Case Else

  End Select


S1xFmtInpValue$ = VALfmt$
                                                                                            Exit Function
'========================================================================================================
DtmErr:
TXTmsg_stp = Error
Resume InpValEnd

InpValEnd:
Exit Function
'========================================================================================================
          
          
          If S1xFmtVerCharacter%(VALsav$, "0123456789.", 1) <> 0 Then Exit Function
            
      ERRdtm$ = "Unknown DateFormat"
      ERRday$ = "Invalid Day"
      ERRmnt$ = "Invalid Month"
            
          If Len(VALsav$) > 10 Then TXTmsg_stp = ERRdtm$: Exit Function
       
      P1% = InStr(VALsav$, ".")
        If P1% < 2 Then TXTmsg_stp = ERRdtm$: Exit Function
      P2% = InStr(P1% + 1, VALsav$, ".")
        If P2% < 4 Then TXTmsg_stp = ERRdtm$: Exit Function
          If Len(VALsav$) - P2% > 4 Then TXTmsg_stp = ERRtxt$: Exit Function
      
      DD% = Val(Left$(VALsav$, P1% - 1))
        If DD% = 0 Then TXTmsg_stp = ERRday$: Exit Function
      
      MM% = Val(Mid$(VALsav$, P1% + 1, P2% - P1% - 1))
        If MM% = 0 Or MM% > 12 Then TXTmsg_stp = ERRmnt$: Exit Function
      
      YY& = Val(Right$(VALsav$, Len(VALsav$) - P2%))
        
        If YY& < 100 Then
          If YY& < 45 Then YY& = 2000 + YY& Else YY& = 1900 + YY&
        End If

          If DD% > S1xDtmMntDays%(MM%, YY&) Then TXTmsg_stp = ERRday$: Exit Function
      
      YRSx$ = LTrim$(Str$(YY&)): If YY& < 1000 Then YRSx$ = "0" + YRSx$
      MNTx$ = LTrim$(Str$(MM%)): If MM% < 10 Then MNTx$ = "0" + MNTx$
      DAYx$ = LTrim$(Str$(DD%)): If DD% < 10 Then DAYx$ = "0" + DAYx$
      VALfmt$ = DAYx$ + "." + MNTx$ + "." + YRSx$

'========================================================================================================
                                                                                             End Function

'========================================================================================================
'======================= FORMATIEREN VON WERTEN AUS DER DATENBANK FR DIE ANZEIGE =======================
'
  Function S1xFmtDbsValue$(VALx$, FMTx$)
'
'........................................................................................................


VALfmt$ = Trim(VALx$)

  Select Case Left(FMTx$, 3)

    Case "NBR" '.................................................................................. ZAHLEN
     
        Select Case Mid(FMTx$, 6, 1)
          Case "_" '............................................................................ GanzZahl
            LENmax% = Val(Mid(FMTx$, 5, 1))
            If Mid(FMTx$, 7, 1) = "0" Then VALfmt$ = String(LENmax% - Len(VALfmt$), "0") + VALfmt$
          
          Case "," '......................................................................... DezimalZahl
            Pq% = InStr(VALfmt$, ".")
            If Pq% = 0 Then VALfmt$ = VALfmt$ + ".": Pq% = Len(VALfmt$)
            If Pq% = 1 Then VALfmt$ = "0" + VALfmt$: Pq% = 2
              
            LENdec% = Val(Mid(FMTx$, 7, 1))
            VALfmt$ = Left(VALfmt$, Pq% + LENdec%)
            VALfmt$ = VALfmt$ + String(LENdec% - Len(VALfmt$) + Pq%, "0")
              
            If LCDlng_s1x = "GER" Then Mid(VALfmt$, Pq%, 1) = ","
        
        End Select


  End Select


S1xFmtDbsValue$ = VALfmt$

'========================================================================================================
                                                                                             End Function





'======================================================================================
'============================= LETZTER TAG EINES MONATS ===============================
'
   Function S1xDtmMntDays%(MM%, YY&)
'
'......................................................................................


     If MM% = 2 Then
       MaxDay% = 29

         If YY& Mod 4 = 0 Then

             If YY& Mod 100 = 0 Then
               If YY& Mod 400 <> 0 Then MaxDay% = 28
             End If

         Else
           MaxDay% = 28
         End If

     Else
       MaxDay% = 31

         If MM% < 8 Then
           If MM% Mod 2 = 0 Then MaxDay% = 30
         Else
           If MM% Mod 2 = 1 Then MaxDay% = 30
         End If

     End If

   S1xDtmMntDays% = MaxDay%

'======================================================================================
                                                                           End Function


'********************************************************************************************************
'********************************* EINBLENDEN GEBUNDENER FORMULARE **************************************
'
    Sub S1xFrmShwModal(OBJfrm_s1x, LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%)
'
'........................................................................................................

S1X_DMY.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%
On Error Resume Next
S1X_DMY.Show
On Error GoTo 0

OBJfrm_s1x.Move LFTfrm%, TOPfrm%, WDTfrm%, HGHfrm%

OBJfrm_s1x.AutoRedraw = 1
OBJfrm_s1x.DrawWidth = 2

C1& = &HFFFFFF: C2& = &H808080
OBJfrm_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), C1&, B
OBJfrm_s1x.Line (15, HGHfrm% - 15)-(WDTfrm% - 15, HGHfrm% - 15), C2&
OBJfrm_s1x.Line (WDTfrm% - 15, 30)-(WDTfrm% - 15, HGHfrm% - 15), C2&

OBJfrm_s1x.DrawWidth = 1
OBJfrm_s1x.Line (0, 0)-(WDTfrm% - 15, HGHfrm% - 15), 0, B
OBJfrm_s1x.PSet (15, HGHfrm% - 15), C2&
OBJfrm_s1x.PSet (WDTfrm% - 15, 15), C2&


'********************************************************************************************************
                                                                                                  End Sub

'========================================================================================================
'========================================================================================================
'
  Function S1xIniSection(INI$, SCTx$)
'
'........................................................................................................

    
S1xIniSection = ""

Pq% = InStr(UCase(INI$), "[" + UCase(SCTx$) + "]")
  If Pq% = 0 Then Exit Function
      
P1% = InStr(Pq%, INI$, Chr$(10)) + 1
  If P1% = 1 Then Exit Function

P2% = InStr(P1%, INI$, Chr$(10) + "[") + 1
  If P2% = 1 Then P2% = Len(INI$) + 1

S1xIniSection = Chr$(10) + Mid(INI$, P1%, P2% - P1%)

'========================================================================================================
                                                                                             End Function









'========================================================================================================
'========================================================================================================
'
   Function S1xIniOption(SCTtxt$, OPTx$)
'
'........................................................................................................

IniS1xIniOption = ""

Pq% = InStr(UCase(SCTtxt$), Chr(10) + OPTx$)
  If Pq% = 0 Then Exit Function
      
P1% = InStr(Pq%, SCTtxt$, "=") + 1
  If P1% = 1 Then Exit Function
              
P2% = InStr(P1%, SCTtxt$, Chr$(13))
  If P2% = 0 Then P2% = Len(SCTtxt$) + 1

OptTxt$ = Trim(Mid$(SCTtxt$, P1%, P2% - P1%))

Pq% = InStr(OptTxt$, "'.")
  If Pq% > 0 Then OptTxt$ = Left(OptTxt$, Pq% - 1)

S1xIniOption = OptTxt$

'========================================================================================================
                                                                                             End Function




'********************************************************************************************************
'********************************************************************************************************
'
  Sub S1xIniAltitude()
'
'........................................................................................................


Pi090 = 2 * Atn(1)
Pi180 = 3.14159265358979
Pi270 = 4.71238898038469
Pi360 = 6.28318530717958


'------------------------------------------ DEFAULT SETTINGS --------------------------------------------
#If Win16 Then
  DBSver_s1x = "dbase iv"
#Else
  DBSver_s1x = "dBase 5.0"
#End If

LCDlng_s1x = "ENG" '...................................................... LnderCode der AnwenderSprache

'....................................................................................... EINGABE-BEREICHE
FRCinp_foc = 0: BKCinp_foc = &HFFFFFF: BLDinp_foc = 1 '........................... Aktive EingabeBereiche
FRCinp_nrm = 0: BKCinp_nrm = &HC0C0C0: BLDinp_nrm = 1 '......................... Inaktive EingabeBereiche

'................................................................................................. LISTEN
COLrec_lst = &HFFFF00: BLDrec_lst = 0 '................................................ Daten der Records
COLfrm_lst = &HFFFF&: BLDfrm_lst = 0: HGHfrm_lst = 225 '................................... AuswahlRahmen
COLbkc_lst = 0 '....................................................................... ListenHintergrund
TOPspc_lst = 90 '............................................................................ Oberer Rand
HGHrow_lst = 270 '......................................................................... ZeilenAbstand

S1Xzom_stp = 1000000000#

'............................................................................................ S1X-CONTROL
LSTfrm_opn = Space(5)

'............................................................................................... SETTINGS
LFTfrm_set = 4140: TOPfrm_set = 4650

'................................................................................................... STOP
LFTfrm_stp = 5745: TOPfrm_stp = 4410

'...................................................................................... KONTROLL-ABFRAGEN
LFTfrm_ask = 4095: TOPfrm_ask = 4545

'................................................................................................... INFO
LFTfrm_inf = 2460: TOPfrm_inf = 3945

'................................................................................................ CONTEST
IDXcnt_s1x = 1
LFTcnt_lst = 3930: TOPcnt_lst = 2460: NRWcnt_lst = 9 '............................................. Liste
LFTcnt_edt = 5205: TOPcnt_edt = 2985  '............................................................ Editor
NRWimp_lst = 10

'............................................................................................... STATIONS
StcCtr.LFTfrm = 1740: StcCtr.TOPfrm = 3000: StcCtr.NBRrow = 5 '............................ HauptFormular
LFTstc_edt = 6000: TOPstc_edt = 3825 '............................................................ Editor
LFTstc_lst = 7695: TOPstc_lst = 2475: NRWstc_lst = 5 '........................................... Auswahl
LFTstc_err = 4440: TOPstc_err = 3195 '............................................ Settings ErrorHandling

HRZerr_max = 5: VTCerr_max = 5 '........................................ Zulssige Abweichungen der Paare
NBRmin_max = 5 '...................................... MindestAnzahl Paare fr Streichung der ExtremWerte
HGHerr_max = 10 '.................................................. Zulssige Abweichungen der HhenWerte

'................................................................................................ RESULTS
CmpCtr.LFTfrm = 6690: CmpCtr.TOPfrm = 1635: CmpCtr.NBRrow = 12 '........................... HauptFormular
LFTcmp_edt = 4455: TOPcmp_edt = 5955 '............................................................ Editor
LFTcmp_lod = 3150: TOPcmp_lod = 2445: NRWcmp_lod = 7 '.............................. Wettkmpfer Kopieren

'................................................................................................ FLIGHTS
MsrCtr.LFTfrm = 180: MsrCtr.TOPfrm = 6645: MsrCtr.NBRrow = 3 '............................. HauptFormular

'........................................................................................... CALCULATIONS
ClcCtr.LFTfrm = 8145: ClcCtr.TOPfrm = 5910: ClcCtr.NBRrow = 3 '............................ HauptFormular

'............................................. VIEWS ....................................................
'........................................................................................................
DSThrz_s1x = 3000 '......................................................... Entfernung der HorizontLinie

KRKv3d_foc = 1500  '................................. Parallaxe (Abstand der Abbildungen in der FocusTiefe)
COLv3d_s1x(1, 2) = &HFFFF& '................................................ Farbe fr linkes BrillenGlas
COLv3d_s1x(2, 2) = &HFF& '................................................. Farbe fr rechtes BrillenGlas
    
XXXobs_stc = 1500: YYYobs_stc = 1077: ZZZobs_stc = 1400 '...................... ObserverPosition Stations
SPDimz_stc = 142 '.................................................. Anzahl Schritte fr StartStellenZoom
WDTfoc_stc = 1.5 * Screen.Width '............................................................. BrennWeite
LFTscc_stc = 0.55 * Screen.Width: TOPscc_stc = 0.65 * Screen.Height '......... Abbildung des FocusPunktes

XXXobs_fly = 1500: YYYobs_fly = 1107: ZZZobs_fly = 1400 '....................... ObserverPosition Flights
WDTfoc_fly = 1.5 * Screen.Width '............................................................. BrennWeite
LFTscc_fly = 0.55 * Screen.Width: TOPscc_fly = 0.65 * Screen.Height '......... Abbildung des FocusPunktes


FLNx$ = "S1X_??.EXE"

  On Error Resume Next
    If Dir(FLNx$) = "" Then ChDrive Left(App.Path, 1): ChDir App.Path
    If Dir(FLNx$) = "" Then ChDrive "C": ChDir "C:\PROJECTS\S1X"
    If Dir(FLNx$) = "" Then ChDrive "C": ChDir "C:\S1X_CD\S1X.SRC"
    If Dir(FLNx$) = "" Then ChDrive "D": ChDir "D:\BASIC\PROJECTS\S1X"
  On Error GoTo 0
    
    
    If Dir(FLNx$) = "" Then
      TXTmsg_stp = "- So Sorry! - S1X-HomeDirectory not found -"
      S1X_STP.Show 1
      End
    End If
    
DIRhom_s1x = CurDir


S1xIniLodSettings
  
  If TXTmsg_stp > "" Then
    TXTmsg_stp = TXTmsg_stp + " Starting with default Settings -"
    S1X_STP.Show 1
  End If
  
  If Dir(DIRhom_s1x + "\s1x_info." + LCDlng_s1x) = "" Then
      
      If LCDlng_s1x = "GER" Then
          
          If Dir(DIRhom_s1x + "\s1x_info.eng") > "" Then
            LCDlng_s1x = "ENG"
            TXTmsg_stp = "Die InfoDatei  [S1X_INFO." + LCDlng_s1x + "]  ist nicht verfgbar."
            TXTmsg_stp = TXTmsg_stp + " Alle InfoTexte werden in Englisch ausgegeben."
          End If
          
      Else
          
          If Dir(DIRhom_s1x + "\s1x_info.ger") > "" Then
            LCDlng_s1x = "GER"
            TXTmsg_stp = "Info-File  [S1X_INFO." + LCDlng_s1x + "]  not found."
            TXTmsg_stp = TXTmsg_stp + " InformationText will come in German."
          End If
      
      End If
            
    If TXTmsg_stp = "" Then TXTmsg_stp = "Info-File  [S1X_INFO." + LCDlng_s1x + "]  not found."
    S1X_STP.Show 1
  End If

'............................................................................................ SystemDatum
DTMsys_nbr = Mid$(Date$, 4, 2) + "." + Left(Date$, 2) + "." + Right(Date$, 4)

  '................................................................................... Schwache 3D-Farben
  For GLSi% = 1 To 2
    COLx& = COLv3d_s1x(GLSi%, 2)

    BLUx& = Int(COLx& / 256 ^ 2) '........................................................... Blau-Anteil
    COLx& = COLx& - BLUx& * 256 ^ 2
    GRNx& = Int(COLx& / 256) '............................................................... Grn-Anteil
    
    REDx& = COLx& - GRNx& * 256 '............................................................. Rot-Anteil
  
    COLv3d_s1x(GLSi%, 1) = Fix(0.7 * BLUx&) * 256 ^ 2 + Fix(0.7 * GRNx&) * 256 + Fix(0.7 * REDx&)
  Next GLSi%

'********************************************************************************************************
                                                                                                  End Sub


'********************************************************************************************************
'********************************************************************************************************
'
  Sub S1xIniLodSettings()
'
'........................................................................................................


FLNini$ = DIRhom_s1x + "\S1X.INI"
  If Dir$(FLNini$) = "" Then TXTmsg_stp = "- File S1X.INI not found.": Exit Sub

Open FLNini$ For Input As #99
INI$ = Input$(LOF(99), #99)
Close #99
    
SCTtxt$ = S1xIniSection(INI$, "S1X")
  If SCTtxt$ = "" Then TXTmsg_stp = "- File S1X.INI is invalid -": Exit Sub

LFTs1x_ctr = Val(S1xIniOption(SCTtxt$, "LFT_S1X"))
TOPs1x_ctr = Val(S1xIniOption(SCTtxt$, "TOP_S1X"))

LFTfrm_set = Val(S1xIniOption(SCTtxt$, "LFT_SET"))
TOPfrm_set = Val(S1xIniOption(SCTtxt$, "TOP_SET"))

COLrec_lst = Val(S1xIniOption(SCTtxt$, "COL_REC"))
BLDrec_lst = Val(S1xIniOption(SCTtxt$, "BLD_REC"))

COLfrm_lst = Val(S1xIniOption(SCTtxt$, "COL_FRM"))
BLDfrm_lst = Val(S1xIniOption(SCTtxt$, "BLD_FRM"))
COLbkc_lst = Val(S1xIniOption(SCTtxt$, "COL_LST"))
  If COLrec_lst = COLbkc_lst Then COLbkc_lst = 0: COLrec_lst = &HFFFFFF
    If COLfrm_lst = COLbkc_lst Then COLfrm_lst = &HFFFF&

S1Xzom_stp = Val(S1xIniOption(SCTtxt$, "ZOM_STP"))
  If S1Xzom_stp = 0 Then S1Xzom_stp = 50000000000#

MODv3d_s1x = Val(S1xIniOption(SCTtxt$, "MOD_D3D"))

LFTfrm_stp = Val(S1xIniOption(SCTtxt$, "LFT_STP"))
TOPfrm_stp = Val(S1xIniOption(SCTtxt$, "TOP_STP"))

LFTfrm_ask = Val(S1xIniOption(SCTtxt$, "LFT_ASK"))
TOPfrm_ask = Val(S1xIniOption(SCTtxt$, "TOP_ASK"))

LFTfrm_inf = Val(S1xIniOption(SCTtxt$, "LFT_INF"))
TOPfrm_inf = Val(S1xIniOption(SCTtxt$, "TOP_INF"))

PTHdbs_s1x = S1xIniOption(SCTtxt$, "DBS_S1X")
LCDlng_s1x = S1xIniOption(SCTtxt$, "LNG_S1X"): If LCDlng_s1x = "" Then LCDlng_s1x = "GER"
IDXcnt_s1x = Val(S1xIniOption(SCTtxt$, "IDX_CNT")): If IDXcnt_s1x = 0 Then IDXcnt_s1x = 1

SCTtxt$ = S1xIniSection(INI$, "CONTEST")
  If SCTtxt$ > "" Then
    LFTcnt_lst = Val(S1xIniOption(SCTtxt$, "LFT_LST"))
    TOPcnt_lst = Val(S1xIniOption(SCTtxt$, "TOP_LST"))
    NRWcnt_lst = Val(S1xIniOption(SCTtxt$, "NRW_LST")): If NRWcnt_lst < 3 Then NRWcnt_lst = 3
    NRWimp_lst = Val(S1xIniOption(SCTtxt$, "NRW_IMP")): If NRWimp_lst < 3 Then NRWimp_lst = 3
    LFTcnt_edt = Val(S1xIniOption(SCTtxt$, "LFT_EDT"))
    TOPcnt_edt = Val(S1xIniOption(SCTtxt$, "TOP_EDT"))
  End If

SCTtxt$ = S1xIniSection(INI$, "STATIONS")
  If SCTtxt$ > "" Then
    StcCtr.LFTfrm = Val(S1xIniOption(SCTtxt$, "LFT_CTR"))
    StcCtr.TOPfrm = Val(S1xIniOption(SCTtxt$, "TOP_CTR"))
    StcCtr.NBRrow = Val(S1xIniOption(SCTtxt$, "NRW_CTR")): If StcCtr.NBRrow < 3 Then StcCtr.NBRrow = 3
    
    LFTstc_edt = Val(S1xIniOption(SCTtxt$, "LFT_EDT"))
    TOPstc_edt = Val(S1xIniOption(SCTtxt$, "TOP_EDT"))
    
    LFTstc_lst = Val(S1xIniOption(SCTtxt$, "LFT_LST"))
    TOPstc_lst = Val(S1xIniOption(SCTtxt$, "TOP_LST"))
    NRWstc_lst = Val(S1xIniOption(SCTtxt$, "NRW_LST")): If NRWstc_lst < 3 Then NRWstc_lst = 3
    
    LFTstc_err = Val(S1xIniOption(SCTtxt$, "LFT_ERR"))
    TOPstc_err = Val(S1xIniOption(SCTtxt$, "TOP_ERR"))

  End If

SCTtxt$ = S1xIniSection(INI$, "RESULTS")
  If SCTtxt$ > "" Then
    CmpCtr.LFTfrm = Val(S1xIniOption(SCTtxt$, "LFT_CTR"))
    CmpCtr.TOPfrm = Val(S1xIniOption(SCTtxt$, "TOP_CTR"))
    CmpCtr.NBRrow = Val(S1xIniOption(SCTtxt$, "NRW_CTR")): If CmpCtr.NBRrow < 3 Then CmpCtr.NBRrow = 3
    
    LFTcmp_lod = Val(S1xIniOption(SCTtxt$, "LFT_LOD"))
    TOPcmp_lod = Val(S1xIniOption(SCTtxt$, "TOP_LOD"))
    NRWcmp_lod = Val(S1xIniOption(SCTtxt$, "NRW_LOD")): If NRWcmp_lod < 3 Then NRWcmp_lod = 3
    
    LFTcmp_edt = Val(S1xIniOption(SCTtxt$, "LFT_EDT"))
    TOPcmp_edt = Val(S1xIniOption(SCTtxt$, "TOP_EDT"))
  End If

SCTtxt$ = S1xIniSection(INI$, "FLIGHTS")
  If SCTtxt$ > "" Then
    MsrCtr.LFTfrm = Val(S1xIniOption(SCTtxt$, "LFT_CTR"))
    MsrCtr.TOPfrm = Val(S1xIniOption(SCTtxt$, "TOP_CTR"))
  End If

SCTtxt$ = S1xIniSection(INI$, "CALCULATIONS")
  If SCTtxt$ > "" Then
    ClcCtr.LFTfrm = Val(S1xIniOption(SCTtxt$, "LFT_CTR"))
    ClcCtr.TOPfrm = Val(S1xIniOption(SCTtxt$, "TOP_CTR"))
  End If


'.................................................................................................. VIEWS
SCTtxt$ = S1xIniSection(INI$, "VIEWS")
  
  If SCTtxt$ > "" Then
    SPDimz_stc = Val(S1xIniOption(SCTtxt$, "STP_IST")): If SPDimz_stc = 0 Then SPDimz_stc = 140
    KRKv3d_foc = Val(S1xIniOption(SCTtxt$, "KRK_FOC")): If KRKv3d_foc = 0 Then KRKv3d_foc = 140
    
    COLv3d_s1x(1, 2) = Val(S1xIniOption(SCTtxt$, "COL_LFT"))
    If COLv3d_s1x(1, 2) = 0 Then COLv3d_s1x(1, 2) = &HFFFF&
    
    COLv3d_s1x(2, 2) = Val(S1xIniOption(SCTtxt$, "COL_RGT"))
    If COLv3d_s1x(2, 2) = 0 Then COLv3d_s1x(2, 2) = &HFF&
  End If


'********************************************************************************************************
                                                                                                  End Sub










'********************************************************************************************************
'********************************************************************************************************
'
  Sub S1xIniSavSettings()

'
'........................................................................................................


FLNini$ = DIRhom_s1x + "\S1X.INI"
Open FLNini$ For Output As #99

Print #99, "[S1X]"
Print #99, "LFT_S1X ="; LFTs1x_ctr: Print #99, "TOP_S1X ="; TOPs1x_ctr
Print #99, "LFT_SET ="; LFTfrm_set: Print #99, "TOP_SET ="; TOPfrm_set

Print #99, "COL_REC ="; COLrec_lst: Print #99, "BLD_REC ="; BLDrec_lst
Print #99, "COL_FRM ="; COLfrm_lst: Print #99, "BLD_FRM ="; BLDfrm_lst
Print #99, "COL_LST ="; COLbkc_lst

Print #99, "LFT_STP ="; LFTfrm_stp: Print #99, "TOP_STP ="; TOPfrm_stp
Print #99, "LFT_ASK ="; LFTfrm_ask: Print #99, "TOP_ASK ="; TOPfrm_ask
Print #99, "LFT_INF ="; LFTfrm_inf: Print #99, "TOP_INF ="; TOPfrm_inf

Print #99, "LNG_S1X = "; LCDlng_s1x: Print #99, "DBS_S1X = "; PTHdbs_s1x
Print #99, "IDX_CNT ="; IDXcnt_s1x
Print #99, "ZOM_STP ="; Str(S1Xzom_stp)
Print #99, "MOD_D3D ="; Str(MODv3d_s1x)

Print #99, ""

Print #99, "[CONTEST]"
Print #99, "LFT_LST ="; LFTcnt_lst: Print #99, "TOP_LST ="; TOPcnt_lst
Print #99, "NRW_LST ="; NRWcnt_lst
Print #99, "NRW_IMP ="; NRWimp_lst

Print #99, "LFT_EDT ="; LFTcnt_edt: Print #99, "TOP_EDT ="; TOPcnt_edt
Print #99, ""

Print #99, "[STATIONS]"
Print #99, "LFT_CTR ="; StcCtr.LFTfrm: Print #99, "TOP_CTR ="; StcCtr.TOPfrm
Print #99, "NRW_CTR ="; StcCtr.NBRrow
Print #99, "LFT_EDT ="; LFTstc_edt: Print #99, "TOP_EDT ="; TOPstc_edt
Print #99, "LFT_LST ="; LFTstc_lst: Print #99, "TOP_LST ="; TOPstc_lst
Print #99, "NRW_LST ="; NRWstc_lst
Print #99, "LFT_ERR ="; LFTstc_err: Print #99, "TOP_ERR ="; TOPstc_err
Print #99, ""

Print #99, "[RESULTS]"
Print #99, "LFT_CTR ="; CmpCtr.LFTfrm: Print #99, "TOP_CTR ="; CmpCtr.TOPfrm
Print #99, "NRW_CTR ="; CmpCtr.NBRrow
Print #99, "LFT_EDT ="; LFTcmp_edt: Print #99, "TOP_EDT ="; TOPcmp_edt
Print #99, "LFT_LOD ="; LFTcmp_lod: Print #99, "TOP_LOD ="; TOPcmp_lod
Print #99, "NRW_LOD ="; NRWcmp_lod
Print #99, ""

Print #99, "[FLIGHTS]"
Print #99, "LFT_CTR ="; MsrCtr.LFTfrm: Print #99, "TOP_CTR ="; MsrCtr.TOPfrm
Print #99, ""

Print #99, "[CALCULATIONS]"
Print #99, "LFT_CTR ="; ClcCtr.LFTfrm: Print #99, "TOP_CTR ="; ClcCtr.TOPfrm
Print #99, ""

Print #99, "[VIEWS]"
Print #99, "STP_IST ="; SPDimz_stc
Print #99, "KRK_FOC ="; KRKv3d_foc
Print #99, "COL_LFT ="; COLv3d_s1x(1, 2)
Print #99, "COL_RGT ="; COLv3d_s1x(2, 2)
Print #99, ""


Close #99

'********************************************************************************************************
                                                                                                  End Sub










